/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k;

import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.cim.provider.rs6k.Activator;
import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.cim.provider.rs6k.HscProviderUtils;
import com.ibm.hsc.cim.provider.rs6k.NVRAM;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HscProviderSocket;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.common.util.VersionComparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.client.ProviderCIMOMHandle;
import org.snia.wbemcfg.GlobalConfig;

public class DLPARUtils {
    static final int dlpar_method = 15;
    static final int ADD = 1;
    static final int MOVE = 3;
    static final int REMOVE = 2;
    static final int RECOVER = 4;
    static final short CPU_BIT = 1;
    static final short MEM_BIT = 2;
    static final short IO_BIT = 4;
    static final int STATE_STOPPED = 7;
    static final int PROC_UNASSIGNED = 0;
    static final int PROC_RECOVER = 255;
    static final int CPU_RESOURCE = 1;
    static final int IO_RESOURCE = 2;
    public static final int SLOT_OPERATION_SUCC = 0;
    public static final int SLOT_INITIAL_VAL = 1;
    public static final int SLOT_IS_REQUIRED = 2;
    public static final int SLOT_INVALID_STATE = 3;
    public static final int SLOT_ID_NOT_MATCH = 4;
    public static final int SLOT_SAME_GROUP = 5;
    public static final int SLOT_WRONG_SRC_PARTITION = 6;
    public static final int SLOT_OPERATION_FAILED = 7;

    protected static CIMValue cpuDlparTask(CIMObjectPath cIMObjectPath, Vector vector, Vector vector2, HscProviderSocket hscProviderSocket, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        Trace.trace("apcshscD", "in DLPARUtils.cpuDlparTask method");
        System.out.println("In cpuDlparTask!");
        String[] stringArray = new String[2];
        int n = 0;
        try {
            int n2;
            Object object;
            Object object2;
            int n3;
            int n4;
            if (GlobalConfig.callMethodsWithValues) {
                n4 = ((UnsignedInt8)((CIMValue)vector.elementAt(0)).getValue()).intValue();
                n3 = ((UnsignedInt8)((CIMValue)vector.elementAt(1)).getValue()).intValue();
            } else {
                n4 = ((UnsignedInt8)((CIMProperty)vector.elementAt(0)).getValue().getValue()).intValue();
                n3 = ((UnsignedInt8)((CIMProperty)vector.elementAt(1)).getValue().getValue()).intValue();
            }
            System.out.println("destination part. ID: " + n4);
            System.out.println("Quantity: " + n3);
            CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_Partition"), false);
            System.out.println("Partition instance: " + cIMInstance);
            String string = (String)cIMInstance.getProperty("Name").getValue().getValue();
            String string2 = string.substring(string.indexOf(42) + 1);
            System.out.println("cec name: " + string2);
            short s = Short.parseShort(string.substring(0, 3));
            System.out.println("partition slot ID: " + s);
            CIMObjectPath cIMObjectPath2 = HscProviderUtils.slot2cop(n4, string2);
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscV3_2");
            cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
            cIMObjectPath3.addKey("Name", new CIMValue((Object)string2));
            CIMInstance cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath3, providerCIMOMHandle.getClass(cIMObjectPath3, false), false);
            String string3 = (String)cIMInstance2.getProperty("CSPVersion").getValue().getValue();
            System.out.println("The csp version is :" + string3);
            Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_CEC_STATE", null, hscProviderSocket, string3);
            short s2 = ((Integer)hashtable.get("CEC_STATE")).shortValue();
            if (s2 == 3) {
                System.out.println("CEC is powered off - can't do DLPAR op!");
                throw new HSCCIMException("2912");
            }
            int n5 = DLPARUtils.getOperType(s, n4);
            int n6 = ((UnsignedInt32)cIMInstance.getProperty("DLPARCapabilities").getValue().getValue()).intValue();
            System.out.println("Source DLPAR Capability: " + n6);
            if (((short)n6 & 1) != 1) {
                System.out.println("Partition is not DLPAR capable for CPUs!");
                throw new HSCCIMException("2901");
            }
            System.out.println("source partition is DLPAR capable");
            if (n5 == 3) {
                object2 = providerCIMOMHandle.getClass(cIMObjectPath2, false);
                object = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_Partition"), false);
                System.out.println("Destination partition instance: " + object);
                n2 = ((UnsignedInt32)object.getProperty("DLPARCapabilities").getValue().getValue()).intValue();
                System.out.println("Destination partition DLPAR Capability: " + n2);
                if (((short)n2 & 1) != 1) {
                    throw new HSCCIMException("2902");
                }
            }
            hashtable = HscProviderUtils.doCSPCommand("GET_ALL_PROC_LPAR_ASSIGN_VALUE", null, hscProviderSocket, string3);
            object2 = (Vector)hashtable.get("ALL_PROC_ASSIGNMENT");
            System.out.println("All assignment values: " + object2);
            hashtable = HscProviderUtils.doCSPCommand("GET_INSTALLED_PROC_STATE_VALUE", null, hscProviderSocket, string3);
            object = (Vector)hashtable.get("ALL_PROC_STATE");
            System.out.println("All processors' states: " + object);
            n2 = 0;
            int n7 = 0;
            int n8 = 0;
            while (n8 < ((Vector)object2).size()) {
                if (((Integer)((Vector)object2).elementAt(n8)).shortValue() == s) {
                    ++n2;
                }
                if ((Integer)((Vector)object2).elementAt(n8) == n4) {
                    ++n7;
                }
                ++n8;
            }
            System.out.println("Num. assigned: " + n2);
            System.out.println("destNumAssigned: " + n7);
            CIMObjectPath cIMObjectPath4 = new CIMObjectPath("IBMHSC_ActivatedLparProfile", "root/ibmhscV3_2");
            Vector vector3 = CimomWrapper.associatorNames((CIMOMHandle)providerCIMOMHandle, cIMObjectPath4, cIMObjectPath, null, "Element", "Setting");
            System.out.println("activatedInst = " + vector3);
            CIMObjectPath cIMObjectPath5 = (CIMObjectPath)vector3.elementAt(0);
            cIMObjectPath5.setNameSpace("root/ibmhscV3_2");
            System.out.println("The cimobject path of the activated lpar profile :" + cIMObjectPath5);
            CIMInstance cIMInstance3 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath5, new CIMClass(cIMObjectPath5.getObjectName()), false);
            System.out.println("The Activated lpar profile instance is :" + cIMInstance3);
            int n9 = ((UnsignedInt8)cIMInstance3.getProperty("MinimumCPUCount").getValue().getValue()).intValue();
            System.out.println("min. CPU: " + n9);
            int n10 = ((UnsignedInt8)cIMInstance3.getProperty("MaximumCPUCount").getValue().getValue()).intValue();
            System.out.println("max. CPU: " + n10);
            if (n5 == 3) {
                cIMObjectPath4 = new CIMObjectPath("IBMHSC_ActivatedLparProfile", "root/ibmhscV3_2");
                vector3 = CimomWrapper.associatorNames((CIMOMHandle)providerCIMOMHandle, cIMObjectPath4, cIMObjectPath2, null, "Element", "Setting");
                System.out.println("destination activatedInst = " + vector3);
                cIMObjectPath5 = (CIMObjectPath)vector3.elementAt(0);
                cIMObjectPath5.setNameSpace("root/ibmhscV3_2");
                System.out.println("The cimobject path of the activated destination lpar profile :" + cIMObjectPath5);
                cIMInstance3 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath5, new CIMClass(cIMObjectPath5.getObjectName()), false);
                System.out.println("The activated dest. lpar profile instance is ;" + cIMInstance3);
                n10 = ((UnsignedInt8)cIMInstance3.getProperty("MaximumCPUCount").getValue().getValue()).intValue();
                System.out.println("dest. max CPU: " + n10);
            }
            if ((n5 == 2 || n5 == 3) && n2 - n3 < n9) {
                System.out.println("Below minimum!!");
                System.out.println("minimum CPU: " + n9);
                System.out.println("number assigned: " + n2);
                int n11 = n2 - n9;
                String string4 = Integer.toString(n11);
                System.out.println("most that can be removed: " + string4);
                throw new HSCCIMException("2903", new String[]{string4});
            }
            if ((n5 == 1 || n5 == 3) && n7 + n3 > n10) {
                System.out.println("Above maximum!");
                System.out.println("maximum CPU: " + n10);
                System.out.println("number assigned: " + n7);
                int n12 = n10 - n7;
                String string5 = Integer.toString(n12);
                System.out.println("most that can be added: " + string5);
                throw new HSCCIMException("2904", new String[]{string5});
            }
            hashtable = HscProviderUtils.doCSPCommand("GET_PROCESSORS_STATUS_VALUES", null, hscProviderSocket, string3);
            Vector vector4 = (Vector)hashtable.get("ALL_PROC_STATUS");
            System.out.println("All processors' statuses: " + vector4);
            int n13 = 0;
            Vector<Integer> vector5 = new Vector<Integer>();
            Vector<Integer> vector6 = new Vector<Integer>();
            Vector<Integer> vector7 = new Vector<Integer>();
            try {
                int n14;
                int n15;
                int n16;
                int n17;
                int n18;
                int n19 = 0;
                while (n19 < n3) {
                    n18 = n13;
                    while (n18 < ((Vector)object).size()) {
                        System.out.println("j= " + n18);
                        n17 = 0;
                        n16 = (Integer)((Vector)object).elementAt(n18);
                        System.out.println("proc. state: " + n16);
                        n15 = (Integer)((Vector)object2).elementAt(n18);
                        n14 = (Integer)vector4.elementAt(n18);
                        System.out.println("assignment val.: " + n15);
                        if ((n14 == 1 || n14 == 3) && (short)n16 == 7) {
                            if (n5 == 3 || n5 == 2) {
                                if (n15 == s) {
                                    System.out.println("MOVE/REMOVE - found one!");
                                    vector5.addElement(new Integer(n18));
                                    n13 = n18 + 1;
                                    System.out.println("ctr: " + n13);
                                    break;
                                }
                            } else if (n5 == 1) {
                                if (n15 == 0) {
                                    System.out.println("ADD - found one!");
                                    vector5.addElement(new Integer(n18));
                                    n13 = n18 + 1;
                                    System.out.println("ctr: " + n13);
                                    break;
                                }
                                stringArray = new String[]{Integer.toHexString(n15)};
                                hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_STATE", stringArray, hscProviderSocket, string3);
                                int n20 = (Integer)hashtable.get("LPAR_STATE");
                                System.out.println("LPAR " + n15 + "'s state: " + n20);
                                hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_SLOT_DEFINITION_STATE", stringArray, hscProviderSocket, string3);
                                int n21 = (Integer)hashtable.get("DEFINITION_STATE");
                                if (n20 == 1 && !vector6.contains(new Integer(n18))) {
                                    System.out.println("ADD - found a usable assigned one!");
                                    vector6.addElement(new Integer(n18));
                                    if (n21 == 10) {
                                        vector7.addElement(new Integer(n15));
                                    } else {
                                        vector7.addElement(new Integer(0));
                                    }
                                }
                            } else {
                                throw new HSCCIMException("2913");
                            }
                        }
                        ++n18;
                    }
                    ++n19;
                }
                System.out.println("assignedUsable: " + vector6);
                System.out.println("Num. processors found: " + vector5.size());
                n18 = vector5.size();
                System.out.println("goodProcs Vector: " + vector5);
                if (n5 == 1 && n18 < n3) {
                    System.out.println("need to use some assigned processors!");
                    n17 = n3 - n18;
                    n16 = 0;
                    n16 = vector6.size() <= n17 ? vector6.size() : n17;
                    n15 = 0;
                    while (n15 < n16) {
                        vector5.addElement((Integer)vector6.elementAt(n15));
                        n14 = (Integer)vector7.elementAt(n15);
                        if (n14 != 0) {
                            stringArray = new String[]{Integer.toHexString(n14), Integer.toHexString(11)};
                            hashtable = HscProviderUtils.doCSPCommand("SET_LPAR_SLOT_DEFINITION_STATE", stringArray, hscProviderSocket, string3);
                            System.out.println("Set slot def. state to invalid!");
                        }
                        ++n15;
                    }
                    System.out.println("Now, goodProcs vector: " + vector5);
                    n18 = vector5.size();
                }
                System.out.println("numProcs: " + n18);
                n17 = 0;
                while (n17 < n18) {
                    n16 = (Integer)vector5.elementAt(n17);
                    System.out.println("processor ID: " + n16);
                    stringArray = new String[2];
                    stringArray[0] = Integer.toHexString(n16);
                    if (n5 == 3) {
                        stringArray[1] = Integer.toHexString(n4);
                    }
                    if (n5 == 2) {
                        stringArray[1] = Integer.toHexString(0);
                    }
                    if (n5 == 1) {
                        stringArray[1] = Integer.toHexString(s);
                    }
                    hashtable = HscProviderUtils.doCSPCommand("SET_PROC_LPAR_ASSIGN_VALUE", stringArray, hscProviderSocket, string3);
                    ++n;
                    hashtable = HscProviderUtils.doCSPCommand("GET_ALL_PROC_LPAR_ASSIGN_VALUE", null, hscProviderSocket, string3);
                    Vector vector8 = (Vector)hashtable.get("ALL_PROC_ASSIGNMENT");
                    System.out.println("Now, assignment values: " + vector8);
                    n14 = 1;
                    DLPARUtils.updateCPUAssocs(n5, n16, string2, s, cIMObjectPath2, providerCIMOMHandle);
                    ++n17;
                }
                DLPARUtils.sendResAssignBroadcastEvt(HscProviderUtils.getHscID((CIMOMHandle)providerCIMOMHandle), 0, s, n4, vector5, null, hscProviderSocket);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            DLPARUtils.deFastActivate(new Integer(s), new Integer(n4), string2, hscProviderSocket);
            System.out.println("Number of successes: " + n);
            UnsignedInt8 unsignedInt8 = new UnsignedInt8((short)n);
            vector2.setSize(1);
            if (GlobalConfig.callMethodsWithValues) {
                vector2.setElementAt(new CIMValue((Object)unsignedInt8), 0);
            } else {
                vector2.setElementAt(new CIMProperty("CPUSuccesses", new CIMValue((Object)unsignedInt8)), 0);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            throw new HSCCIMException(throwable);
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    protected static CIMValue memDlparTask(CIMObjectPath cIMObjectPath, Vector vector, HscProviderSocket hscProviderSocket, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        Hashtable hashtable = null;
        boolean bl = false;
        Trace.trace("aphphscT", "-> memLPARTask");
        if (GlobalConfig.debugLevel((int)15) > 0) {
            System.out.println("In memDlparTask method!");
            System.out.println("In vector: " + vector);
        }
        try {
            String[] stringArray;
            Object object;
            long l;
            Object object2;
            Object object3;
            long l2;
            long l3;
            boolean bl2;
            int n;
            int n2;
            CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, new CIMClass(cIMObjectPath.getObjectName()), false);
            System.out.println("The partition instance is :" + cIMInstance);
            String string = (String)cIMInstance.getProperty("Name").getValue().getValue();
            System.out.println("partitionName = " + string);
            int n3 = string.indexOf(42);
            String string2 = string.substring(n3 + 1);
            System.out.println("The CEC name is = " + string2);
            int n4 = Integer.parseInt(string.substring(0, n3));
            System.out.println("The source partition ID is = " + n4);
            if (GlobalConfig.callMethodsWithValues) {
                n2 = ((UnsignedInt8)((CIMValue)vector.elementAt(0)).getValue()).intValue();
                n = ((UnsignedInt32)((CIMValue)vector.elementAt(1)).getValue()).intValue();
                bl2 = (Boolean)((CIMValue)vector.elementAt(2)).getValue();
            } else {
                n2 = ((UnsignedInt8)((CIMProperty)vector.elementAt(0)).getValue().getValue()).intValue();
                n = ((UnsignedInt32)((CIMProperty)vector.elementAt(1)).getValue().getValue()).intValue();
                bl2 = (Boolean)((CIMProperty)vector.elementAt(2)).getValue().getValue();
            }
            System.out.println("The destination slot ID is :" + n2);
            System.out.println("The memory LMB Quantity :" + n);
            int n5 = DLPARUtils.getOperType(n4, n2);
            System.out.println("The operation type is :" + n5);
            int n6 = ((UnsignedInt32)cIMInstance.getProperty("DLPARCapabilities").getValue().getValue()).intValue();
            System.out.println("The source partition capability is : " + n6);
            if (((short)n6 & 2) != 2) {
                throw new HSCCIMException("2905");
            }
            if (n5 == 3) {
                CIMObjectPath cIMObjectPath2 = HscProviderUtils.slot2cop(n2, string2);
                CIMInstance cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath2, new CIMClass(cIMObjectPath.getObjectName()), false);
                n6 = ((UnsignedInt32)cIMInstance2.getProperty("DLPARCapabilities").getValue().getValue()).intValue();
                System.out.println("The destination partition capability is : " + n6);
                if (((short)n6 & 2) != 2) {
                    throw new HSCCIMException("2906");
                }
            }
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscV3_2");
            cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
            cIMObjectPath3.addKey("Name", new CIMValue((Object)string2));
            CIMInstance cIMInstance3 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath3, providerCIMOMHandle.getClass(cIMObjectPath3, false), false);
            long l4 = ((UnsignedInt32)cIMInstance3.getProperty("LMBSize").getValue().getValue()).longValue();
            String string3 = (String)cIMInstance3.getProperty("CSPVersion").getValue().getValue();
            System.out.println("The csp version is :" + string3);
            int n7 = VersionComparator.CSPVersionValue(string3);
            long l5 = l4 * (long)n;
            System.out.println("mem to reallocate :" + l5);
            hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_MEMORY_RESOURCES", new String[]{Integer.toHexString(n4)}, hscProviderSocket, string3);
            long l6 = (Long)hashtable.get("TOT_MEMORY_REQUESTED");
            System.out.println("The requested memory is :" + l6);
            long l7 = (Long)hashtable.get("POSSIBLE_MEMORY");
            System.out.println("The max memory is :" + l7);
            CIMObjectPath cIMObjectPath4 = new CIMObjectPath("IBMHSC_ActivatedLparProfile", "root/ibmhscV3_2");
            Vector vector2 = CimomWrapper.associatorNames((CIMOMHandle)providerCIMOMHandle, cIMObjectPath4, cIMObjectPath, null, "Element", "Setting");
            System.out.println("activatedInst = " + vector2);
            CIMObjectPath cIMObjectPath5 = (CIMObjectPath)vector2.elementAt(0);
            cIMObjectPath5.setNameSpace("root/ibmhscV3_2");
            System.out.println("The cimobject path of the activated lpar profile :" + cIMObjectPath5);
            CIMInstance cIMInstance4 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath5, new CIMClass(cIMObjectPath5.getObjectName()), false);
            System.out.println("The Activated lpar profile instance is :" + cIMInstance4);
            String string4 = (String)cIMInstance4.getProperty("SettingID").getValue().getValue();
            if (n5 == 1 && !bl2) {
                System.out.println("########Checking aganist avail CEC Mem###########");
                hashtable = HscProviderUtils.doCSPCommand("GET_CEC_MEMORY_RESOURCES", null, hscProviderSocket, string3);
                l3 = (Long)hashtable.get("TOT_AVAILABLE_MEMORY");
                System.out.println("The total available memory in CEC :" + l3);
                l2 = (Long)hashtable.get("REGION_SIZE");
                System.out.println("region size: " + l2);
                int n8 = (Integer)hashtable.get("PAGE_TABLE_RATIO");
                System.out.println("mem to page table ratio: " + n8);
                if (l7 - l6 < l5) {
                    System.out.println("Memory above Max");
                    String string5 = Long.toString(l7 - l6);
                    System.out.println("The memory that can be added:" + string5);
                    throw new HSCCIMException("2907", new String[]{string5});
                }
                object3 = new Activator((byte)n4, string4, cIMObjectPath, hscProviderSocket, (CIMOMHandle)providerCIMOMHandle, true);
                object2 = ((Activator)object3).getFreeMemory(l3, l2, n8);
                l = (Long)((Hashtable)object2).get("freeMem");
                object = (Vector)((Hashtable)object2).get("stealList");
                if (l5 > l) {
                    System.out.println("Memory above available memory");
                    System.out.println("See if we can steal enough....");
                    Hashtable hashtable2 = ((Activator)object3).stealMemForDLPAR(l, l5, l5, (Vector)object);
                    long l8 = (Long)hashtable2.get("memAmt");
                    System.out.println("accum. mem.: " + l8);
                    Byte[] byteArray = (Byte[])hashtable2.get("invalidLpars");
                    if (l8 != -1L && l5 > l8) {
                        String string6 = Long.toString(l8);
                        System.out.println("The memory that can be added:" + string6);
                        throw new HSCCIMException("2909", new String[]{string6});
                    }
                    System.out.println("Invalidating LPARs...");
                    int n9 = 0;
                    while (n9 < byteArray.length) {
                        Byte by = byteArray[n9];
                        System.out.println("LPAR ID: " + by);
                        stringArray = new String[]{Integer.toHexString(by.byteValue()), Integer.toHexString(11)};
                        HscProviderUtils.doCSPCommand("SET_LPAR_SLOT_DEFINITION_STATE", stringArray, hscProviderSocket);
                        ++n9;
                    }
                }
            }
            l3 = 0L;
            l2 = 0L;
            if (n5 == 3 || n5 == 2) {
                CIMObjectPath cIMObjectPath6 = new CIMObjectPath("IBMHSC_ActivatedLparProfile", "root/ibmhscV3_2");
                object3 = CimomWrapper.associatorNames((CIMOMHandle)providerCIMOMHandle, cIMObjectPath6, cIMObjectPath, null, "Element", "Setting").elements();
                object2 = (String[])object3.nextElement();
                object2.setNameSpace("root/ibmhscV3_2");
                System.out.println("The cimobject path of the activated lpar profile :" + object2);
                cIMInstance4 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, (CIMObjectPath)object2, new CIMClass(object2.getObjectName()), false);
                System.out.println("The Activated lpar profile instance is ;" + cIMInstance4);
                l = ((UnsignedInt32)cIMInstance4.getProperty("MinimumMemoryMB").getValue().getValue()).longValue();
                System.out.println("The source min memory is : " + l);
                if (l6 - l < l5) {
                    System.out.println("Memory below Min");
                    object = Long.toString(l6 - l);
                    System.out.println("The memory that can be removed:" + (String)object);
                    throw new HSCCIMException("2908", new String[]{object});
                }
                if (n5 == 3) {
                    hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_MEMORY_RESOURCES", new String[]{Integer.toHexString(n2)}, hscProviderSocket, string3);
                    l3 = (Long)hashtable.get("TOT_MEMORY_REQUESTED");
                    System.out.println("The requested memory is :" + l3);
                    l2 = (Long)hashtable.get("POSSIBLE_MEMORY");
                    long l9 = (Long)hashtable.get("TOT_ALLOC_MEMORY");
                    System.out.println("the total allocate mem: " + l9);
                    System.out.println("The max memory is :" + l2);
                    if (l2 - l3 < l5) {
                        System.out.println("Memory above Max Destination partition");
                        String string7 = Long.toString(l2 - l3);
                        System.out.println("The memory that can be added:" + string7);
                        throw new HSCCIMException("2907", new String[]{string7});
                    }
                }
            }
            if (n5 == 3 || n5 == 2) {
                long l10 = l6 - l5;
                System.out.println("Memory to move/remove : " + l10);
                if (l10 != 0L) {
                    stringArray = new String[]{Integer.toHexString(n4), Integer.toHexString(0), Integer.toHexString(0), Integer.toHexString(0), Long.toString(l10), Long.toString(l7)};
                    HscProviderUtils.doCSPCommand("SET_MEMORY_RESOURCES_FOR_LPAR", stringArray, hscProviderSocket);
                    object2 = new String[]{String.valueOf(l10), String.valueOf(n4)};
                    String string8 = "DLPAR: " + (String)object2[0] + "MB of memory was  removed from partition " + (String)object2[1] + " in CSP.";
                    HSCLogUtils.logSystemEvent((short)2073, string8, (String[])object2, null);
                }
            }
            if (n5 == 3 || n5 == 1) {
                System.out.println("Operation Move/Add");
                long l11 = 0L;
                l11 = n5 == 3 ? l3 + l5 : l6 + l5;
                System.out.println("Memory to move/add :" + l11);
                if (l11 != 0L) {
                    int n10;
                    stringArray = new String[6];
                    if (n5 == 3) {
                        n10 = n2;
                        stringArray[0] = Integer.toHexString(n2);
                        stringArray[5] = Long.toString(l2);
                    } else {
                        n10 = n4;
                        stringArray[0] = Integer.toHexString(n4);
                        stringArray[5] = Long.toString(l7);
                    }
                    stringArray[1] = Integer.toHexString(0);
                    stringArray[2] = Integer.toHexString(0);
                    stringArray[3] = Integer.toHexString(0);
                    stringArray[4] = Long.toString(l11);
                    HscProviderUtils.doCSPCommand("SET_MEMORY_RESOURCES_FOR_LPAR", stringArray, hscProviderSocket);
                    String[] stringArray2 = new String[]{String.valueOf(l11), String.valueOf(n10)};
                    String string9 = "DLPAR: " + stringArray2[0] + "MB of memory was added to partition " + stringArray2[1] + " in CSP.";
                    HSCLogUtils.logSystemEvent((short)2074, string9, stringArray2, null);
                }
            }
            DLPARUtils.deFastActivate(new Integer(n4), new Integer(n2), string2, hscProviderSocket);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            throw new HSCCIMException(throwable);
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    protected static CIMValue ioDlparTask(CIMObjectPath cIMObjectPath, Vector vector, Vector vector2, HscProviderSocket hscProviderSocket, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        if (GlobalConfig.debugLevel((int)15) > 0) {
            System.out.println("in DLPARUtils.ioDlparTask method!");
        }
        Trace.trace("apcshscD", "in DLPARUtils.ioDlparTask method");
        boolean bl = false;
        int n = 0;
        boolean bl2 = false;
        try {
            int n2;
            Object object;
            int n3;
            short s;
            Object object2;
            Vector vector3;
            Vector vector4;
            Vector vector5;
            int n4;
            if (GlobalConfig.callMethodsWithValues) {
                n4 = ((UnsignedInt8)((CIMValue)vector.elementAt(0)).getValue()).intValue();
                vector5 = (Vector)((CIMValue)vector.elementAt(1)).getValue();
                vector4 = (Vector)((CIMValue)vector.elementAt(2)).getValue();
                vector3 = (Vector)((CIMValue)vector.elementAt(3)).getValue();
            } else {
                n4 = ((UnsignedInt8)((CIMProperty)vector.elementAt(0)).getValue().getValue()).intValue();
                vector5 = (Vector)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                vector4 = (Vector)((CIMProperty)vector.elementAt(2)).getValue().getValue();
                vector3 = (Vector)((CIMProperty)vector.elementAt(3)).getValue().getValue();
            }
            String string = "";
            CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_Partition"), false);
            String string2 = (String)cIMInstance.getProperty("Name").getValue().getValue();
            String string3 = string2.substring(string2.indexOf(42) + 1);
            short s2 = Short.parseShort(string2.substring(0, 3));
            CIMObjectPath cIMObjectPath2 = HscProviderUtils.slot2cop(n4, string3);
            int n5 = DLPARUtils.getOperType(s2, n4);
            int n6 = ((UnsignedInt32)cIMInstance.getProperty("DLPARCapabilities").getValue().getValue()).intValue();
            if (((short)n6 & 4) != 4) {
                throw new HSCCIMException("290B");
            }
            if (n5 == 3) {
                CIMClass cIMClass = providerCIMOMHandle.getClass(cIMObjectPath2, false);
                object2 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_Partition"), false);
                int n7 = ((UnsignedInt32)object2.getProperty("DLPARCapabilities").getValue().getValue()).intValue();
                if (((short)n7 & 4) != 4) {
                    throw new HSCCIMException("290C");
                }
            }
            int n8 = vector4.size();
            object2 = new short[n8];
            Hashtable<Short, Integer> hashtable = new Hashtable<Short, Integer>();
            Hashtable<Short, Integer> hashtable2 = new Hashtable<Short, Integer>();
            int n9 = 0;
            while (n9 < n8) {
                object2[n9] = 1;
                ++n9;
            }
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath("IBMHSC_ActivatedLparProfile", "root/ibmhscV3_2");
            Vector vector6 = CimomWrapper.associatorNames((CIMOMHandle)providerCIMOMHandle, cIMObjectPath3, cIMObjectPath, null, "Element", "Setting");
            System.out.println("activatedInst = " + vector6);
            CIMObjectPath cIMObjectPath4 = (CIMObjectPath)vector6.elementAt(0);
            cIMObjectPath4.setNameSpace("root/ibmhscV3_2");
            System.out.println("The cimobject path of the activated lpar profile :" + cIMObjectPath4);
            CIMInstance cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath4, new CIMClass(cIMObjectPath4.getObjectName()), false);
            System.out.println("The Activated lpar profile instance is ;" + cIMInstance2);
            Vector vector7 = (Vector)cIMInstance2.getProperty("IODrawer").getValue().getValue();
            System.out.println("IO Drawer vector: " + vector7);
            Vector vector8 = (Vector)cIMInstance2.getProperty("IORequirement").getValue().getValue();
            System.out.println("IO Requirement vector: " + vector8);
            Vector vector9 = (Vector)cIMInstance2.getProperty("IOSlots").getValue().getValue();
            System.out.println("IO Slots vector: " + vector9);
            if (n5 == 2 || n5 == 3) {
                n = 0;
                while (n < n8) {
                    string = (String)vector5.elementAt(n);
                    s = ((UnsignedInt8)vector4.elementAt(n)).shortValue();
                    System.out.println("*********************************************************");
                    System.out.println("Drawer ID and slot ID: " + string + " " + s);
                    System.out.println("*********************************************************");
                    int n10 = vector9.size();
                    int n11 = 0;
                    while (n11 < n10) {
                        System.out.println("Active Drawer ID and slot ID: " + (String)vector7.elementAt(n11) + " " + ((UnsignedInt8)vector9.elementAt(n11)).shortValue());
                        if (string.equals((String)vector7.elementAt(n11)) && s == ((UnsignedInt8)vector9.elementAt(n11)).shortValue()) {
                            System.out.println("ACTIVE slot requirement: " + (String)vector8.elementAt(n11));
                            if (((String)vector8.elementAt(n11)).equals("R")) {
                                System.out.println("ACTIVE slot is REQUIRED");
                                object2[n] = 2;
                                bl2 = true;
                                break;
                            }
                            System.out.println("ACTIVE slot is Desired");
                            bl2 = true;
                            break;
                        }
                        ++n11;
                    }
                    ++n;
                }
            }
            String[] stringArray = new String[1];
            Hashtable<String, Hashtable> hashtable3 = new Hashtable<String, Hashtable>();
            Hashtable hashtable4 = new Hashtable();
            Hashtable hashtable5 = new Hashtable();
            n = 0;
            while (n < n8) {
                bl2 = false;
                if (object2[n] == 1) {
                    string = (String)vector5.elementAt(n);
                    s = ((UnsignedInt8)vector4.elementAt(n)).shortValue();
                    short s3 = ((UnsignedInt8)vector3.elementAt(n)).shortValue();
                    hashtable4 = (Hashtable)hashtable3.get(string);
                    if (hashtable4 == null) {
                        stringArray[0] = string;
                        hashtable4 = HscProviderUtils.doCSPCommand("GET_IO_DRAWER_INFO", stringArray, hscProviderSocket);
                        hashtable3.put(string, hashtable4);
                    }
                    int n12 = (Integer)hashtable4.get("NUM_SLOTS");
                    hashtable5 = (Hashtable)hashtable4.get("SLOT_INFORMATION");
                    n3 = 0;
                    while (n3 < n12) {
                        object = (Hashtable)hashtable5.get(new Integer(n3));
                        n2 = ((Integer)((Hashtable)object).get("SLOT_NO")).shortValue();
                        if (s == n2) {
                            bl2 = true;
                            int n13 = (Integer)((Hashtable)object).get("LPAR_ID");
                            if (n5 == 1 && n13 != 0 && n13 != s2) {
                                Short s4 = new Short(s);
                                Integer n14 = new Integer(n13);
                                if (!hashtable.containsValue(n14) && !hashtable2.containsValue(n14)) {
                                    String[] stringArray2 = new String[]{Integer.toHexString(n14)};
                                    Hashtable hashtable6 = HscProviderUtils.doCSPCommand("GET_LPAR_SLOT_DEFINITION_STATE", stringArray2, hscProviderSocket);
                                    int n15 = (Integer)hashtable6.get("DEFINITION_STATE");
                                    if (n15 == 4) {
                                        hashtable2.put(s4, n14);
                                    } else {
                                        hashtable.put(s4, n14);
                                    }
                                }
                            }
                            if ((n5 == 2 || n5 == 3) && s2 != n13) {
                                object2[n] = 6;
                                break;
                            }
                            int n16 = (Integer)((Hashtable)object).get("IO_STATE");
                            int n17 = (Integer)((Hashtable)object).get("IO_STATUS");
                            System.out.println("Slot id and state: " + s + " " + n16);
                            System.out.println("Slot id and status: " + s + " " + n17);
                            if (n16 == 7 && n17 == 128) break;
                            System.out.println("SLOT is in a bad state - slotID: " + s);
                            object2[n] = 3;
                            if (s3 <= 127) break;
                            int n18 = 0;
                            while (n18 < n8) {
                                if (n18 != n && ((String)vector5.elementAt(n18)).equals(string) && ((UnsignedInt8)vector3.elementAt(n18)).shortValue() == s3) {
                                    object2[n18] = 5;
                                }
                                ++n18;
                            }
                            break;
                        }
                        ++n3;
                    }
                    if (!bl2) {
                        object2[n] = 4;
                    }
                }
                ++n;
            }
            Hashtable hashtable7 = new Hashtable();
            n3 = 0;
            while (n3 < n8) {
                if (object2[n3] == 1) {
                    string = (String)vector5.elementAt(n3);
                    s = ((UnsignedInt8)vector4.elementAt(n3)).shortValue();
                    String[] stringArray3 = new String[3];
                    stringArray3[0] = string;
                    stringArray3[1] = Integer.toHexString(s);
                    if (n5 == 3) {
                        stringArray3[2] = Integer.toHexString(n4);
                    } else if (n5 == 2) {
                        stringArray3[2] = Integer.toHexString(0);
                    } else if (n5 == 1) {
                        stringArray3[2] = Integer.toHexString(s2);
                        object = hashtable.elements();
                        while (object.hasMoreElements()) {
                            Integer n19 = (Integer)object.nextElement();
                            String[] stringArray4 = new String[]{Integer.toHexString(n19), Integer.toHexString(11)};
                            HscProviderUtils.doCSPCommand("SET_LPAR_SLOT_DEFINITION_STATE", stringArray4, hscProviderSocket);
                        }
                    }
                    try {
                        HscProviderUtils.doCSPCommand("SET_IO_SLOT_LPAR_ASSIGN_VALUE", stringArray3, hscProviderSocket);
                        DLPARUtils.updateIOAssocs(n5, s, string, string3, s2, cIMObjectPath2, providerCIMOMHandle);
                        object2[n3] = 0;
                        DLPARUtils.addSlotBroadcastData(hashtable7, string, s);
                    }
                    catch (Throwable throwable) {
                        object2[n3] = 7;
                        throwable.printStackTrace();
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    }
                }
                ++n3;
            }
            if (hashtable7.size() > 0) {
                DLPARUtils.sendSlotAssignBroadcastEvt(HscProviderUtils.getHscID((CIMOMHandle)providerCIMOMHandle), s2, n4, hashtable7, hscProviderSocket);
            }
            object = new UnsignedInt8[n8];
            n2 = 0;
            while (n2 < n8) {
                object[n2] = new UnsignedInt8(object2[n2]);
                ++n2;
            }
            vector2.setSize(1);
            if (GlobalConfig.callMethodsWithValues) {
                vector2.setElementAt(new CIMValue(object, new CIMDataType(21)), 0);
            } else {
                vector2.setElementAt(new CIMProperty("IOResults", new CIMValue(object, new CIMDataType(21))), 0);
            }
            DLPARUtils.deFastActivate(new Integer(s2), new Integer(n4), string3, hscProviderSocket);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new HSCCIMException(throwable);
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    private static void addSlotBroadcastData(Hashtable hashtable, String string, int n) {
        Vector<Integer> vector = (Vector<Integer>)hashtable.get(string);
        if (vector == null) {
            vector = new Vector<Integer>();
            hashtable.put(string, vector);
        }
        vector.addElement(new Integer(n));
    }

    private static void addSlotRecovBroadcastData(Hashtable hashtable, int n, String string, int n2) {
        Integer n3 = new Integer(n);
        Hashtable hashtable2 = (Hashtable)hashtable.get(n3);
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
            hashtable.put(n3, hashtable2);
        }
        DLPARUtils.addSlotBroadcastData(hashtable2, string, n2);
    }

    private static void sendSlotAssignBroadcastEvt(String string, int n, int n2, Hashtable hashtable, HscProviderSocket hscProviderSocket) throws CIMException {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(string2);
            DLPARUtils.sendResAssignBroadcastEvt(string, 2, n, n2, vector, string2, hscProviderSocket);
        }
    }

    private static void sendSlotRecovAssignBroadcastEvt(String string, Hashtable hashtable, HscProviderSocket hscProviderSocket) throws CIMException {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            Hashtable hashtable2 = (Hashtable)hashtable.get(n);
            DLPARUtils.sendSlotAssignBroadcastEvt(string, n, 255, hashtable2, hscProviderSocket);
        }
    }

    private static void addCpuBroadcastData(Hashtable hashtable, int n, int n2) {
        Integer n3 = new Integer(n);
        Vector<Integer> vector = (Vector<Integer>)hashtable.get(n3);
        if (vector == null) {
            vector = new Vector<Integer>();
            hashtable.put(n3, vector);
        }
        vector.addElement(new Integer(n2));
    }

    private static void sendCpuRecovAssignBroadcastEvt(String string, Hashtable hashtable, HscProviderSocket hscProviderSocket) throws CIMException {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(n);
            DLPARUtils.sendResAssignBroadcastEvt(string, 0, n, 255, vector, null, hscProviderSocket);
        }
    }

    private static void sendResAssignBroadcastEvt(String string, int n, int n2, int n3, Vector vector, String string2, HscProviderSocket hscProviderSocket) throws CIMException {
        System.out.println("AsynchEventManager.BCAST_EVT: 0");
        System.out.println("hscId:" + string);
        System.out.println("srcId:" + n2);
        System.out.println("destId: " + n3);
        System.out.println("resIds.size(): " + vector.size());
        byte[] byArray = new byte[vector.size()];
        int n4 = 0;
        while (n4 < byArray.length) {
            int n5 = (Integer)vector.elementAt(n4);
            byArray[n4] = (byte)n5;
            System.out.println("resId[" + n4 + "]: " + byArray[n4] + ", int value:" + n5);
            ++n4;
        }
        System.out.println("drawerId: " + string2);
        if (string2 != null) {
            HscProviderUtils.doCSPCommand("SET_NOTIFICATION_EVENT_CEC_LPAR_IO_ASSIGN", new String[]{"0", string, "2", "32", Integer.toHexString(n2), Integer.toHexString(n3), Integer.toHexString(n), Integer.toHexString(byArray.length), new String(byArray), string2}, hscProviderSocket);
        } else {
            HscProviderUtils.doCSPCommand("SET_NOTIFICATION_EVENT_CEC_LPAR_PROC_ASSIGN", new String[]{"0", string, "2", "32", Integer.toHexString(n2), Integer.toHexString(n3), Integer.toHexString(n), Integer.toHexString(byArray.length), new String(byArray)}, hscProviderSocket);
        }
    }

    public static CIMValue cpuRecover(CIMObjectPath cIMObjectPath, Vector vector, Vector vector2, HscProviderSocket hscProviderSocket, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        System.out.println("Recovering lost processors!");
        String[] stringArray = new String[1];
        int n = 0;
        try {
            Hashtable hashtable = new Hashtable();
            Vector vector3 = new Vector();
            Vector<Integer> vector4 = new Vector<Integer>();
            vector3 = GlobalConfig.callMethodsWithValues ? (Vector)((CIMValue)vector.elementAt(0)).getValue() : (Vector)((CIMProperty)vector.elementAt(0)).getValue().getValue();
            System.out.println("procIDs: " + vector3);
            CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
            String string = (String)cIMInstance.getProperty("CSPVersion").getValue().getValue();
            System.out.println("The csp version is :" + string);
            System.out.println("hi");
            String string2 = (String)cIMInstance.getProperty("Name").getValue().getValue();
            System.out.println("cec name: " + string2);
            Hashtable hashtable2 = HscProviderUtils.getCapabilities(string, hscProviderSocket);
            int n2 = (Integer)hashtable2.get("RuntimeCapability");
            if ((n2 & 0x10) == 0) {
                System.out.println("Managed system is not DLPAR capable!");
                throw new HSCCIMException("290D");
            }
            System.out.println("number of proc id's: " + vector3.size());
            int n3 = 0;
            while (n3 < vector3.size()) {
                try {
                    int n4 = ((UnsignedInt8)vector3.elementAt(n3)).intValue();
                    System.out.println("proc ID: " + n4);
                    stringArray = new String[]{Integer.toHexString(n4)};
                    System.out.println("args: " + stringArray[0]);
                    hashtable2 = HscProviderUtils.doCSPCommand("GET_PROC_STATE", stringArray, hscProviderSocket, string);
                    short s = ((Integer)hashtable2.get("PROC_STATE")).shortValue();
                    System.out.println("State: " + s);
                    hashtable2 = HscProviderUtils.doCSPCommand("GET_PROC_LPAR_ASSIGN_VALUE", stringArray, hscProviderSocket, string);
                    short s2 = ((Integer)hashtable2.get("LPAR_ID")).shortValue();
                    System.out.println("state: " + s);
                    if (s == 7 || s == 2) {
                        System.out.println("Processor is stopped!");
                        stringArray = new String[]{Integer.toHexString(n4), Integer.toHexString(0)};
                        hashtable2 = HscProviderUtils.doCSPCommand("SET_PROC_LPAR_ASSIGN_VALUE", stringArray, hscProviderSocket, string);
                        System.out.println("Success num: " + ++n);
                        vector4.addElement(new Integer(n4));
                        DLPARUtils.updateCPUAssocs(4, n4, string2, s2, null, providerCIMOMHandle);
                        DLPARUtils.addCpuBroadcastData(hashtable, s2, n4);
                        DLPARUtils.deFastActivate(new Integer(s2), null, string2, hscProviderSocket);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
                }
                ++n3;
            }
            System.out.println("Send broadcast event!");
            System.out.println("Number of successes: " + n);
            UnsignedInt8 unsignedInt8 = new UnsignedInt8((short)n);
            vector2.setSize(1);
            if (GlobalConfig.callMethodsWithValues) {
                vector2.setElementAt(new CIMValue((Object)unsignedInt8), 0);
            } else {
                vector2.setElementAt(new CIMProperty("SuccessNum", new CIMValue((Object)unsignedInt8)), 0);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throw new HSCCIMException(throwable);
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    public static CIMValue ioRecover(CIMObjectPath cIMObjectPath, Vector vector, Vector vector2, HscProviderSocket hscProviderSocket, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        System.out.println("Recovering lost adapters!");
        String[] stringArray = new String[1];
        int n = 0;
        Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
        Hashtable hashtable2 = new Hashtable();
        try {
            String string;
            Vector vector3 = new Vector();
            Vector vector4 = new Vector();
            if (GlobalConfig.callMethodsWithValues) {
                vector3 = (Vector)((CIMValue)vector.elementAt(0)).getValue();
                vector4 = (Vector)((CIMValue)vector.elementAt(1)).getValue();
            } else {
                vector3 = (Vector)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                vector4 = (Vector)((CIMProperty)vector.elementAt(1)).getValue().getValue();
            }
            CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
            String string2 = (String)cIMInstance.getProperty("CSPVersion").getValue().getValue();
            System.out.println("The csp version is :" + string2);
            String string3 = (String)cIMInstance.getProperty("Name").getValue().getValue();
            hashtable2 = HscProviderUtils.getCapabilities(string2, hscProviderSocket);
            int n2 = (Integer)hashtable2.get("RuntimeCapability");
            if ((n2 & 0x10) == 0) {
                System.out.println("Managed system is not DLPAR capable!");
                throw new HSCCIMException("290D");
            }
            Hashtable hashtable3 = new Hashtable();
            int n3 = 0;
            while (n3 < vector4.size()) {
                try {
                    string = (String)vector3.elementAt(n3);
                    int n4 = ((UnsignedInt8)vector4.elementAt(n3)).intValue();
                    hashtable2 = (Hashtable)hashtable.get(string);
                    if (hashtable2 == null) {
                        stringArray[0] = string;
                        hashtable2 = HscProviderUtils.doCSPCommand("GET_IO_DRAWER_INFO", stringArray, hscProviderSocket);
                        hashtable.put(string, hashtable2);
                    }
                    int n5 = (Integer)hashtable2.get("NUM_SLOTS");
                    Hashtable hashtable4 = (Hashtable)hashtable2.get("SLOT_INFORMATION");
                    int n6 = 0;
                    while (n6 < n5) {
                        Hashtable hashtable5 = (Hashtable)hashtable4.get(new Integer(n6));
                        int n7 = (Integer)hashtable5.get("SLOT_NO");
                        if (n4 == n7) {
                            int n8 = (Integer)hashtable5.get("LPAR_ID");
                            int n9 = (Integer)hashtable5.get("IO_STATE");
                            if (n9 == 7 || n9 == 12) {
                                stringArray = new String[]{string, Integer.toHexString(n4), Integer.toHexString(0)};
                                HscProviderUtils.doCSPCommand("SET_IO_SLOT_LPAR_ASSIGN_VALUE", stringArray, hscProviderSocket);
                                ++n;
                                DLPARUtils.addSlotRecovBroadcastData(hashtable3, n8, string, n4);
                                DLPARUtils.updateIOAssocs(4, n4, string, string3, n8, null, providerCIMOMHandle);
                                DLPARUtils.deFastActivate(new Integer(n8), null, string3, hscProviderSocket);
                            }
                        }
                        ++n6;
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
                }
                ++n3;
            }
            if (hashtable3.size() > 0) {
                DLPARUtils.sendSlotRecovAssignBroadcastEvt(HscProviderUtils.getHscID((CIMOMHandle)providerCIMOMHandle), hashtable3, hscProviderSocket);
                System.out.println("sent broadcast event!");
            }
            System.out.println("Number of successes: " + n);
            string = new UnsignedInt8((short)n);
            vector2.setSize(1);
            if (GlobalConfig.callMethodsWithValues) {
                vector2.setElementAt(new CIMValue((Object)string), 0);
            } else {
                vector2.setElementAt(new CIMProperty("SuccessNum", new CIMValue((Object)string)), 0);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throw new HSCCIMException(throwable);
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    public static CIMValue memRecover(CIMObjectPath cIMObjectPath, Vector vector, Vector vector2, HscProviderSocket hscProviderSocket, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        Vector vector3 = new Vector();
        Vector<String> vector4 = new Vector<String>();
        try {
            vector3 = GlobalConfig.callMethodsWithValues ? (Vector)((CIMValue)vector.elementAt(0)).getValue() : (Vector)((CIMProperty)vector.elementAt(0)).getValue().getValue();
            CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
            String string = (String)cIMInstance.getProperty("CSPVersion").getValue().getValue();
            System.out.println("The csp version is :" + string);
            String string2 = (String)cIMInstance.getProperty("Name").getValue().getValue();
            System.out.println("Cec name: " + string2);
            Hashtable hashtable = HscProviderUtils.getCapabilities(string, hscProviderSocket);
            int n = (Integer)hashtable.get("RuntimeCapability");
            if ((n & 0x10) == 0) {
                System.out.println("Managed system is not DLPAR capable!");
                throw new HSCCIMException("290E");
            }
            int n2 = 0;
            while (n2 < vector3.size()) {
                try {
                    String string3 = (String)vector3.elementAt(n2);
                    short s = Short.parseShort(string3.substring(0, 3));
                    System.out.println("partition slot ID: " + s);
                    CIMObjectPath cIMObjectPath2 = HscProviderUtils.slot2cop(s, string2);
                    CIMInstance cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_Partition"), false);
                    String string4 = (String)cIMInstance2.getProperty("UserDefinedName").getValue().getValue();
                    hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_MEMORY_RESOURCES", new String[]{Integer.toHexString(s)}, hscProviderSocket, string);
                    long l = (Long)hashtable.get("TOT_MEMORY_REQUESTED");
                    long l2 = (Long)hashtable.get("TOT_ALLOC_MEMORY");
                    long l3 = (Long)hashtable.get("PAGE_TABLE_ALLOC_MEMORY");
                    long l4 = (Long)hashtable.get("POSSIBLE_MEMORY");
                    long l5 = l2 - l3;
                    String[] stringArray = new String[]{Integer.toHexString(s), Integer.toHexString(0), Integer.toHexString(0), Integer.toHexString(0), Long.toString(l5), Long.toString(l4)};
                    HscProviderUtils.doCSPCommand("SET_MEMORY_RESOURCES_FOR_LPAR", stringArray, hscProviderSocket);
                    vector4.addElement(string4);
                    DLPARUtils.deFastActivate(new Integer(s), null, string2, hscProviderSocket);
                    String[] stringArray2 = new String[]{String.valueOf(s)};
                    String string5 = "The requested memory value of partition " + stringArray2[0] + "has been corrected.";
                    HSCLogUtils.logSystemEvent((short)2073, string5, stringArray2, null);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
                }
                ++n2;
            }
            System.out.println("partition success number: " + vector4.size());
            vector2.setSize(1);
            if (GlobalConfig.callMethodsWithValues) {
                vector2.setElementAt(new CIMValue(vector4, new CIMDataType(29)), 0);
            } else {
                vector2.setElementAt(new CIMProperty("Successes", new CIMValue(vector4, new CIMDataType(29))), 0);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throw new HSCCIMException(throwable);
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    public static void updateCPUAssocs(int n, int n2, String string, int n3, CIMObjectPath cIMObjectPath, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        String[] stringArray;
        CIMInstance cIMInstance;
        CIMObjectPath cIMObjectPath2;
        System.out.println("Updating CPU Associations!");
        CIMObjectPath cIMObjectPath3 = new CIMObjectPath("IBMHSC_Processor", "root/ibmhscV3_2");
        cIMObjectPath3.addKey("DeviceID", new CIMValue((Object)new UnsignedInt8((short)n2)));
        cIMObjectPath3.addKey("SystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
        cIMObjectPath3.addKey("SystemName", new CIMValue((Object)string));
        cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Processor"));
        Vector vector = CimomWrapper.referenceNames((CIMOMHandle)providerCIMOMHandle, new CIMObjectPath("IBMHSC_AllocatedProcessor", "root/ibmhscV3_2"), cIMObjectPath3, null);
        boolean bl = false;
        if (vector == null) {
            System.out.println("No Association to delete for allocated processors");
        } else {
            int n4 = 0;
            while (n4 < vector.size()) {
                cIMObjectPath2 = (CIMObjectPath)vector.elementAt(n4);
                if (n == 2 || n == 3 || n == 4 || bl) {
                    CimomWrapper.deleteInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath2);
                    cIMInstance = new CIMInstance[]{String.valueOf(n2), String.valueOf(n3)};
                    if (n == 4) {
                        stringArray = "DLPAR: Processor " + (String)cIMInstance[0] + " was unassigned from partition" + (String)cIMInstance[1] + ".";
                        System.out.println((String)stringArray);
                        HSCLogUtils.logSystemEvent((short)2085, (String)stringArray, (String[])cIMInstance, null);
                    } else {
                        stringArray = "DLPAR: Processor " + (String)cIMInstance[0] + " removed from partition " + (String)cIMInstance[1] + ".";
                        System.out.println((String)stringArray);
                        HSCLogUtils.logSystemEvent((short)2071, (String)stringArray, (String[])cIMInstance, null);
                    }
                } else {
                    cIMInstance = (CIMObjectPath)CimomWrapper.getKeyFromOp(cIMObjectPath2, "GroupComponent");
                    if (cIMInstance.equals((Object)cIMObjectPath)) {
                        System.out.println("The right cpu assign asso inst already exist, no add is needed");
                        bl = true;
                    } else {
                        System.out.println("delete the exist cpu asso inst for add(the lpar assignment is not right");
                        CimomWrapper.deleteInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath2);
                    }
                }
                ++n4;
            }
        }
        if (!(bl || n != 1 && n != 3)) {
            Object object;
            CIMObjectPath cIMObjectPath4 = new CIMObjectPath("IBMHSC_AllocatedProcessor", "root/ibmhscV3_2");
            cIMObjectPath2 = providerCIMOMHandle.getClass(cIMObjectPath4, false);
            cIMInstance = cIMObjectPath2.newInstance();
            cIMInstance.setProperty("GroupComponent", new CIMValue((Object)cIMObjectPath));
            cIMInstance.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath3));
            cIMObjectPath4.setKeys(cIMInstance.getKeyValuePairs());
            System.out.println("new association's cop: " + cIMObjectPath4);
            CimomWrapper.createInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath4, cIMInstance);
            System.out.println("Created new association!");
            stringArray = new String[2];
            stringArray[0] = String.valueOf(n2);
            if (n == 1) {
                stringArray[1] = String.valueOf(n3);
            } else {
                object = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_Partition"), false);
                String string2 = (String)object.getProperty("Name").getValue().getValue();
                int n5 = Integer.parseInt(string2.substring(0, 3));
                stringArray[1] = String.valueOf(n5);
                System.out.println("destination slot ID: " + stringArray[1]);
            }
            object = "DLPAR: Processor " + stringArray[0] + " added to partition " + stringArray[1] + " in CSP.";
            System.out.println((String)object);
            HSCLogUtils.logSystemEvent((short)2072, (String)object, stringArray, null);
        }
    }

    public static void updateIOAssocs(int n, int n2, String string, String string2, int n3, CIMObjectPath cIMObjectPath, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        CIMClass cIMClass;
        Object object;
        Vector vector;
        System.out.println("Updating IO associations!!");
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_PCISlot", "root/ibmhscV3_2");
        cIMObjectPath2.addKey("SlotID", new CIMValue((Object)new UnsignedInt8((short)n2)));
        cIMObjectPath2.addKey("IODrawerDeviceID", new CIMValue((Object)string));
        cIMObjectPath2.addKey("IODrawerSystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
        cIMObjectPath2.addKey("IODrawerSystemName", new CIMValue((Object)string2));
        cIMObjectPath2.addKey("IODrawerCreationClassName", new CIMValue((Object)"IBMHSC_IODrawer"));
        if (n == 3 || n == 2 || n == 4) {
            vector = CimomWrapper.referenceNames((CIMOMHandle)providerCIMOMHandle, new CIMObjectPath("IBMHSC_AllocatedSlot", "root/ibmhscV3_2"), cIMObjectPath2, null);
            if (vector == null) {
                System.out.println("NO (NULL) ASSOCIATIONS  -----------------------");
            } else if (vector.size() == 0) {
                System.out.println("NO (ZERO) ASSOCIATIONS  -----------------------");
            } else {
                int n4 = 0;
                while (n4 < vector.size()) {
                    object = (CIMObjectPath)vector.elementAt(n4);
                    System.out.println("THE INSTANCE is " + object);
                    CimomWrapper.deleteInstance((CIMOMHandle)providerCIMOMHandle, (CIMObjectPath)object);
                    ++n4;
                }
            }
            cIMClass = new CIMClass[]{String.valueOf(n3)};
            if (n == 4) {
                object = "DLPAR: IO resource was unassigned from partition " + (String)cIMClass[0] + ".";
                System.out.println((String)object);
                HSCLogUtils.logSystemEvent((short)2086, (String)object, (String[])cIMClass, null);
            } else {
                object = "DLPAR: IO resource(s) removed from partition " + (String)cIMClass[0] + ".";
                System.out.println((String)object);
                HSCLogUtils.logSystemEvent((short)2075, (String)object, (String[])cIMClass, null);
            }
        }
        if (n == 3 || n == 1) {
            Object object2;
            vector = new CIMObjectPath("IBMHSC_AllocatedSlot", "root/ibmhscV3_2");
            cIMClass = providerCIMOMHandle.getClass((CIMObjectPath)vector, false);
            object = cIMClass.newInstance();
            object.setProperty("GroupComponent", new CIMValue((Object)cIMObjectPath));
            object.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath2));
            vector.setKeys(object.getKeyValuePairs());
            CimomWrapper.createInstance((CIMOMHandle)providerCIMOMHandle, (CIMObjectPath)vector, object);
            String[] stringArray = new String[1];
            if (n == 1) {
                stringArray[0] = String.valueOf(n3);
            } else {
                object2 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_Partition"), false);
                String string3 = (String)object2.getProperty("Name").getValue().getValue();
                int n5 = Integer.parseInt(string3.substring(0, 3));
                System.out.println("destination slot ID: " + n5);
                stringArray[0] = String.valueOf(n5);
            }
            object2 = "DLPAR: IO resource(s) were added to partition " + stringArray[0] + " in CSP.";
            System.out.println((String)object2);
            HSCLogUtils.logSystemEvent((short)2076, (String)object2, stringArray, null);
        }
    }

    public static int getOperType(int n, int n2) {
        if (n == n2) {
            return 1;
        }
        if (n2 == 0) {
            return 2;
        }
        if (n2 == -1) {
            return 4;
        }
        return 3;
    }

    private static void deFastActivate(Integer n, Integer n2, String string, HscProviderSocket hscProviderSocket) throws CIMException {
        NVRAM nVRAM = (NVRAM)NVRAM.NVRAM_TABLE.get(string);
        if (nVRAM == null) {
            System.out.println("deFastActivate:: nvram table is null for CecName: " + string);
        }
        try {
            if (n != null && n > 0) {
                nVRAM.setFastActivation(n, false, hscProviderSocket);
            }
            if (n2 != null && n2 > 0) {
                nVRAM.setFastActivation(n2, false, hscProviderSocket);
            }
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
            HSCLogUtils.serverLog(cIMException, HSCLogUtils._CECClassLogInfo);
            throw new HSCCIMException(cIMException);
        }
    }
}

